%% (c) 2002 by Polish TeX Users Group (GUST), <http://www.gust.org.pl>
%%
%% This work may be distributed under the terms of the LaTeX Project
%% Public License, as described in lppl.txt in the base LaTeX
%% distribution.  Either version 1.0 or, at your option, any later
%% version.
%%
%% LaTeX2e class file for formating documents for publishing
%% in GUST bulletin, the official newsletter of the Polish TeX 
%% Users Group. This file requires `gustcmn.def' file.
%%
%% For newest version see: http://www.gust.org.pl/BIUL
%%
%% Usage (example file preamble):
%% Spos\'ob wykorzystania (przyk\l{}adowa preambu\l{}a dokumentu):
%% -----
% %& --translate-file=il2-pl
% \documentclass{gust}
% \usepackage{polski} % lub zakomentuj ten wiersz
% %\usepackage[polish]{babel} % i odkomentuj ten
% %\usepackage[OT4]{fontenc}  % oraz ten.
% %\usepackage[latin2]{inputenc} % odkomentuj je\.zeli nie
% % korzystasz z plik\'ow `.tcx' 
% \PrelimDraftfalse
% \title{Tytu dokumentu}
% \author{Imi Nazwisko autora}
% \address{Miasto, ulica itd}
% \netaddress{autor@domena.pl}
% \begin{document}
% \maketitle
% ... itd ...
%
% ------
% Change history:
% 15/1/2002 (v. 1.1): first public release
%
\NeedsTeXFormat{LaTeX2e}[94/12/01]

\def\thisstyle{latex}
\def\fileversion{v1.1}
\def\filedate{15 January 2002}

\ifx\styloaded@\thisstyle \styinit
 \endinput\else\let\styloaded@\thisstyle\fi

\ProvidesClass{gust}[2002/01/01 Document class GUST \fileversion]

\ifx\c@section\undefined \LoadClass{article} \fi

% \RequirePackage[plmath,MeX]{polski}
\input gustcmn.def
\RequirePackage{euler} % ** tp **

%%SW!%\font \bdingbatfont=pzd scaled \magstep1  % marginal dingbats
\font \bdingbatfont=qzdr at15pt % marginal dingbats

\renewcommand\rmdefault{ccr}

%% for section titles; include explicit definition of |\La| (for |\LaTeX|)
  \def\sectitlefont{%\def\La{\leavevmode L\raise.42ex
%                    \hbox{\fontsize{12}{12pt}\selectfont\kern-.4em A}}%
          \fontfamily{cmss}\fontseries{bx}\fontshape{n}%
          \fontsize\@xviipt{\stbaselineskip}\selectfont}
  \def\tensl{\fontfamily{cmr}\fontseries{m}\fontshape{sl}\fontsize{10}{12pt}%
          \selectfont}
  \def\tenss{\fontfamily{cmss}\fontseries{m}\fontshape{n}\fontsize{10}{12pt}%
          \selectfont}
  \def\tubfont{\fontshape{sl}\selectfont}
  \def\gustfont{\fontshape{sl}\selectfont}
  \def\tenuit{\fontfamily{cmr}\fontseries{m}\fontshape{u}\fontsize{10}{12pt}%
          \selectfont}
  \def\elevenss{\fontfamily{cmss}\fontseries{m}\fontshape{n}%
          \fontsize\@xipt{13pt}%
          \selectfont}

\@twosidetrue         % for odd/even asymmetry in running heads
\twocolumn            % two columns
\sloppy               % make those columns justify but ensure they line up
\columnsep 1.5pc      % space between columns
\columnwidth 18.75pc  % width of each column
\parindent \normalparindent     % paragraph indent
\parskip 0pt plus .5pt  % no inter-paragraph space
\leftmargini 2em      % unchanged
\leftmarginv .5em     % ditto 
\leftmarginvi .5em    % ditto 
\oddsidemargin 0pt    % was 42pt
\evensidemargin 0pt   % was 84pt
\topmargin -2.5pc     % was 0pt
\headheight 12pt      % height of running head, unchanged
\headsep 20pt         % distance between header and text
\marginparwidth 48pt  % don't use marginal notes
\marginparsep 10pt    %  in TUGboat
\textheight 54pc      % height of text on page
\textwidth 39pc       % total width of a page

\partopsep=\z@
%%\topsep=3pt plus1pt minus1pt
%%\parsep=3pt plus 1pt minus 1pt
\topsep=0pt plus1pt % ** TP **
\parsep=0pt plus 1pt % ** TP **
\itemsep=\parsep

%% ** TP **:
\renewcommand\normalsize{%
   \@setfontsize\normalsize\@xpt{13pt}%
   \abovedisplayskip 3\p@ \@plus2\p@ \@minus1\p@
   \abovedisplayshortskip \z@ \@plus3\p@
   \belowdisplayshortskip 1\p@ \@plus3\p@ \@minus1\p@
   \belowdisplayskip \abovedisplayskip
   \def\@listi{\leftmargin\leftmargini
      \topsep 3\p@ \@plus1\p@ \@minus2\p@
      \parsep 0\p@ \@plus.5\p@ 
      \itemsep 2\p@ \@plus.5\p@ \@minus.5\p@ }%
   \belowdisplayskip \abovedisplayskip 
   \let\@listI \@listi \@listi}
\normalsize
\renewcommand\small{%
   \@setfontsize\small\@ixpt{11}%
   \abovedisplayskip 3\p@ \@plus2\p@ \@minus4\p@
   \abovedisplayshortskip \z@ \@plus2\p@
   \belowdisplayshortskip 1\p@ \@plus2\p@ \@minus2\p@
   \def\@listi{\leftmargin\leftmargini
      \topsep 4\p@ \@plus2\p@ \@minus2\p@
       \parsep 2\p@ \@plus\p@ \@minus\p@ \itemsep \parsep}%
   \belowdisplayskip \abovedisplayskip 
}

\def\SMC{\small}

\def\footnotesize{\@setsize\footnotesize{12pt}\xpt\@xpt
\abovedisplayskip=3pt plus 3pt minus 1pt \belowdisplayskip=\abovedisplayskip
\abovedisplayshortskip=\z@ plus3pt \belowdisplayshortskip=1pt plus3pt minus1pt}

\def\@listi{\leftmargin\leftmargini\parsep=1pt plus 1pt minus 1pt
  \itemsep=\parsep
  \listparindent=1em }

\def\@listii{\leftmargin\leftmarginii
  \labelwidth=\leftmarginii \advance\labelwidth-\labelsep
  %%\topsep=2pt plus 1pt minus 1pt
  \topsep=0pt plus 1pt  % ** TP **
  \parsep=1pt plus 1pt minus 1pt
  \itemsep=\parsep
  \listparindent=1em }

\def\@listiii{\leftmargin=\leftmarginiii
  \labelwidth=\leftmarginiii \advance\labelwidth-\labelsep
  \topsep=0pt plus 1pt
  \parsep=\z@
  \itemsep=\topsep
  \listparindent=1em }

\setbox\T@stBox=\hbox{\sectitlefont O}
\newdimen\stfontheight \stfontheight=\ht\T@stBox
\newdimen\stfontwidth \stfontwidth=\wd\T@stBox
\def\sectitle#1#2{\SecTitletrue \def\s@ctitle{#1}\def\s@clogo{#2}}

\newcount\authornumber
\authornumber=0

\def\author#1{%
  \global\advance\authornumber\@ne
  \expandafter\def\csname theauthor\number\authornumber\endcsname
      {\ignorespaces#1\unskip}%
  \expandafter\let\csname theaddress\number\authornumber\endcsname\relax
  \expandafter\let\csname thenetaddress\number\authornumber\endcsname\relax
  }

\def\address#1{%
  \expandafter\def\csname theaddress\number\authornumber\endcsname
      {\ignorespaces#1\unskip}}

\def\netaddress#1{%
  \expandafter\def\csname thenetaddress\number\authornumber\endcsname
      {\ignorespaces#1\unskip}}

\def\authorlist#1{\def\@author{#1}}
\def\@author{\@defaultauthorlist}

\def\maketitle{\par
 \ifdim\PreTitleDrop > 0pt
   \loop
   \ifdim \PreTitleDrop > \textheight
     \vbox{}\vfil\eject
     \advance\PreTitleDrop by -\textheight
   \repeat
   \vbox to \PreTitleDrop{}
   \global\PreTitleDrop=0pt
 \fi
 \begingroup
 \setcounter{footnote}{0}
 \def\thefootnote{\fnsymbol{footnote}}
%% |\def\@makefnmark{\hbox to 0pt{$^{\@thefnmark}$\hss}}|
 \@maketitle
 \@thanks
 \endgroup
 \setcounter{footnote}{0}
%% |\let\maketitle\relax|
%% |\let\@maketitle\relax|
 \gdef\@thanks{}%
%% |\let\thanks\relax|
 }

\newif\ifWideSecTitle
\def\@maketitle{\ifSecTitle \global\SecTitlefalse
                \T@stDimen=\hsize
                \ifWideSecTitle \hsize=\textwidth \global\WideSecTitlefalse \fi
                \SectionTitle{\s@ctitle}{{\bdingbatfont\s@clogo}}%
                \hsize=\T@stDimen
        \else \vskip\AboveTitleSkip
                \kern\topskip
                \hrule height\z@ depth\z@ width 10pt
                \kern-\topskip
                \kern-\strulethickness
                \hrule height\strulethickness depth\z@
                \kern\medskipamount
                \nobreak
        \fi
        {\nohyphens \interlinepenalty\@M
        \setbox0=
          \hbox{\let\thanks\@gobble
                \let\\=\quad
                \let\and=\quad
                \ignorespaces\@author}%
        {\noindent\elevenss\fontseries{bx}\selectfont
          \raggedright\ignorespaces\@title\endgraf}%
        \ifdim \wd0 < 5pt               % omit if author is null
        \else \nobreak \vskip 4pt       % 4pt + |\BelowTitleSkip| = |%
%\baselineskip|
                {\leftskip=\normalparindent
                 \raggedright
                 \def\and{\unskip\\}%
                 \noindent\elevenss\@author\endgraf}%
        \fi \nobreak \vskip\BelowTitleSkip }}

\def\dedication{\bgroup\raggedright\let\MF=\slMF\noindent\it\ignorespaces}
\def\enddedication{\endgraf\egroup\medskip}

\def\abstract{%
\section*{\abstractname}
}
\def\endabstract{}

\def\longabstract{%
  \section*{\abstractname}
  \bgroup\small}
\def\endlongabstract{\endgraf\egroup
  \vspace{.25\baselineskip}
  \begin{center}
    {$--*--$}
  \end{center}
  \vspace{.5\baselineskip}}

\def\section{\@startsection {section}{1}{\z@}{-8pt}{4pt}%
        {\normalsize\elevenss\fontseries{bx}\selectfont\raggedright\hyphenpenalty=\@M}}

\def\subsection{\@startsection{subsection}{2}{\z@}{-8pt}{4pt}%
        {\normalsize\tenss\fontseries{bx}\selectfont\raggedright\hyphenpenalty=\@M}}

\def\subsubsection{\@startsection{subsubsection}{3}{\z@}{-8pt}{4pt}%
        {\normalsize\tenss\fontseries{bx}\selectfont\raggedright\hyphenpenalty=\@M}}

\def\paragraph{\@startsection
 {paragraph}{4}{\z@}{2.5ex plus 1ex}{-1em}{\normalsize\tenss\fontseries{bx}\selectfont}}

\def\subparagraph{\@startsection
 {subparagraph}{4}{\parindent}{2.5ex plus 1ex}{-1em}{\normalsize\tenss\fontseries{bx}\selectfont}}

%%Modify |\appendix| from |art10.sty|, to add ``Appendix''
%%1 May 89 Mittelbach comments that we need to put ``Appendix''
%%somewhere other than |\thesection| if |\tableofcontents| is used.

%%|\def\appendix{\par|

%%|\setcounter{section}{0}|
%%|\setcounter{subsection}{0}|

%%|\def\thesection{Appendix \Alph{section}}}|

\def\l@part#1#2{\addpenalty{\@secpenalty}
 \addvspace{2.25em plus 1pt} \begingroup
 \@tempdima 3em \parindent \z@ \rightskip \z@ \parfillskip \z@
 {\large \fontseries{bx}\selectfont \leavevmode #1\hfil \hbox to\@pnumwidth{\hss #2}}\par
 \nobreak \endgroup}
\def\l@section#1#2{\addpenalty{\@secpenalty} \addvspace{1.0em plus 1pt}
\@tempdima 1.5em \begingroup
 \parindent \z@ \rightskip \z@  % article style makes |\rightskip > 0|
 \parfillskip \z@
 \fontseries{bx}\selectfont \leavevmode \advance\leftskip\@tempdima \hskip -\leftskip #1\nobreak\hfil
\nobreak\hbox to\@pnumwidth{\hss #2}\par
 \endgroup}

\def \EdNote{{\tenuit Od redakcji:\enspace }}

\long\def\@makefntext#1{\parindent 1em\noindent\hbox to 2em{}%
  \llap{\@makefnmark}\null$\mskip5mu$#1}

\ifnum\number\language=0
\def\fnum@figure{{\fontseries{bx}\selectfont Figure \thefigure}}
\else
\def\fnum@figure{{\fontseries{bx}\selectfont Rycina \thefigure}}
\fi

\def\quote{\list{}{\rightmargin.5\leftmargin}\item[]}

%% From Dominik Wujastyk's font article.  First paragraph of a quotation
%% will not be indented, and right margin is decreased for narrow columns.

\renewcommand{\quotation}{\list{}{\listparindent 1.5em
        \rightmargin.5\leftmargin\parsep 0pt plus 1pt}\item[]}

%% Replace |\sloppy| by something not quite as sloppy

\def\thebibliography#1{\section*{\refname\@mkboth
  {\refname}{\refname}}\list
  {[\arabic{enumi}]}{\settowidth\labelwidth{[#1]}\leftmargin\labelwidth
    \advance\leftmargin\labelsep
    \usecounter{enumi}}
    \def\newblock{\hskip .11em plus .33em minus .07em}
%%    |\sloppy|
    \tolerance 8000 \hfuzz .5\p@ \vfuzz .5\p@
    \clubpenalty4000\widowpenalty4000
    \sfcode`\.=1000\relax}

%%|\def\sloppy{\tolerance 10000 \hfuzz .5\p@ \vfuzz .5\p@}|

\def\enddocument{\@checkend{document}\clearpage\begingroup
\if@filesw \immediate\closeout\@mainaux
\def\global\@namedef##1##2{}\def\newlabel{\@testdef r}%
\def\bibcite{\@testdef b}\@tempswafalse \makeatletter\@@input \jobname.aux
\if@tempswa \@warning{Label(s) may have changed.  Rerun to get
cross-references right}\fi\fi\endgroup\deadcycles\z@\@@end}

\def\rtitlex{\def\gustfont{\normalsize\rm}\GUSTB, \volx }

\def\PrelimDraftfooter{%
  \dlap{\kern\textheight\kern3pc
        \rlap{\hbox to \pagewd{\midrtitle\hfil\midrtitle}}
  }}

\def\MakeRegistrationMarks{}
\def\MakeRegistrationMarks{}
\def\UseTrimMarks{%
  \def\MakeRegistrationMarks{%
    \ulap{\rlap{%
       \vbox{\dlap{\vbox to\trimlgt{\vfil\botregister}}%
             \topregister\vskip \headmargin \vskip 10pt}}}}%
  }

\def\@oddhead{\MakeRegistrationMarks\PrelimDraftfooter
  \normalsize\csname normalshape\endcsname\rm
  \volyr\hfil\rtitlex\hfil\thepage}
\def\@evenhead{\MakeRegistrationMarks\PrelimDraftfooter
  \normalsize\csname normalshape\endcsname\rm
  \thepage\hfil\rtitlex\hfil\volyr}
\def\@oddfoot{}
\def\@evenfoot{}

\def\ps@headings{}
\pagestyle{headings}

\def\@outputdblcol{\if@firstcolumn \global\@firstcolumnfalse
    \global\setbox\@leftcolumn\box\@outputbox
    \global\brokenpenalty10000
  \else \global\@firstcolumntrue
    \global\brokenpenalty100
    \setbox\@outputbox\vbox{\hbox to\textwidth{\hbox to\columnwidth
      {\box\@leftcolumn \hss}\hfil \vrule width\columnseprule\hfil
       \hbox to\columnwidth{\box\@outputbox \hss}}}\@combinedblfloats
       \@outputpage \begingroup \@dblfloatplacement \@startdblcolumn
       \@whilesw\if@fcolmade \fi{\@outputpage\@startdblcolumn}\endgroup
    \fi}

\def\SelfDocumenting{%
  \setlength\textwidth{31pc}
  \onecolumn
  \parindent 0pt
  %%\parskip 2pt plus 1pt minus 1pt
  \parskip 0pt plus 1pt % ** TP **
  \oddsidemargin 8pc
  \evensidemargin 8pc
  \marginparwidth 8pc
  \toks@\expandafter{\@oddhead}%
  \xdef\@oddhead{\hss\hbox to \pagewd{\the\toks@}}%
  \toks@\expandafter{\@evenhead}%
  \xdef\@evenhead{\hss\hbox to \pagewd{\the\toks@}}%
  \def\ps@titlepage{}%
}

\def\ps@titlepage{}

\newif\ifFirstPar       \FirstParfalse

\newdimen\pagewd        \pagewd=39pc
\newdimen\trimwd        \trimwd=\pagewd
\newdimen\trimlgt       \trimlgt=11in
\newdimen\headmargin    \headmargin=3.5pc
\def\smc{\sc}
\def\ninepoint{\small}
\newdimen\colwd         \colwd=18.75pc  % for compatibility with |gust.sty|
\countdef\xcol=1        \xcol=1

\setcounter{page}{1001}
\PrelimDrafttrue

\def\gstyinit{%
  \everypar{\@nodocument}%
  \authornumber\z@
  \let\@signature\@defaultsignature
  }

%% Fullstop after section numbers ** TP **:
\renewcommand{\@seccntformat}[1]{\csname the#1\endcsname.\hspace{.5em}\relax}
\flushbottom %% ** TP **

\endinput
